function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_Fracking_IRF.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(76, 1);
residual(1) = T(32)+T(36)+params(25)*y(132)-y(93);
residual(2) = T(26)*(-exp(y(27)))+y(85)*(-(T(31)*params(4)*exp(y(27)*params(4))))+exp(y(27))*y(69)+params(25)*y(134)-y(95);
residual(3) = y(83)*(-(T(29)*params(4)*exp(y(28)*params(4))))+y(74)*y(39)*T(29)*params(4)*(params(4)-1)*exp(y(28)*(params(4)-1))+exp(y(28))*y(69)+params(25)*y(133)-y(94);
residual(4) = T(26)*T(37)+y(89)*(-exp(y(29)))+exp(y(29))*y(88)+params(25)*y(136)-y(97);
residual(5) = y(89)*(-exp(y(30)))+exp(y(30))*y(86)+params(25)*y(135)-y(96);
residual(6) = T(39);
residual(7) = T(41);
residual(8) = T(42);
residual(9) = T(43);
residual(10) = T(45)+params(25)*y(131)*(-exp(y(35)));
residual(11) = T(40)+y(75)*T(46)+y(72)*T(47)+params(25)*y(119)*exp(y(32))*params(6)*params(5)*exp(params(5)*y(36))+T(48);
residual(12) = exp(y(37))*y(68);
residual(13) = y(73)*(-params(7))+y(72)+T(33)*y(20)*(-(T(24)*(1-exp(y(11)))))+T(33)*T(24)*y(22);
residual(14) = params(4)*exp(y(28)*(params(4)-1))*T(29)*y(74)+y(73)+T(33)*y(21)*(-(T(24)*(1-params(7))));
residual(15) = T(8)*y(89)+y(65)*(-(params(11)*T(12)*T(49)))+y(64)*(-(params(11)*T(50)*T(51)));
residual(16) = y(69)*(-exp(y(41)))+y(67)*(-(T(5)*T(19)*T(16)*T(53)))+y(66)*(-(T(17)*T(3)*T(16)*T(54)))+y(65)*(-(T(14)*params(11)*T(52)))+exp(y(41))*y(64)+params(25)*y(137)-y(98);
residual(17) = T(20)*y(69)+params(25)*y(115)*(-(T(61)*T(64)))+params(25)*y(116)*(-(T(65)*(T(57)*T(67)*T(68)+T(58)*T(67)*T(70))))+params(25)*y(117)*T(74)+params(25)*y(118)*(-(exp((1-params(3))*y(106))*exp(T(1)*y(110))*params(3)*exp(params(3)*y(42))))+params(25)*y(119)*(-(T(20)*(1-params(10))));
residual(18) = (T(37)-exp(y(27)))*T(78)+y(71)*(-(params(1)*T(78)/T(28)))+T(4)*y(70)+y(68)*T(80)+y(67)*T(84)+y(66)*T(86)+y(64)*(-(T(51)*T(88)))+params(25)*y(120)*(-((-(T(78)*T(90)))/(T(26)*T(26))));
residual(19) = (T(37)-exp(y(27)))*T(91)+y(71)*T(92)+exp(y(44))*y(69)+params(25)*y(120)*(-((-(T(90)*T(91)))/(T(26)*T(26))));
residual(20) = exp(y(45))*y(67)+T(33)*y(19)*(-(exp(y(45))*T(24)));
residual(21) = y(70)*(-(T(21)*T(93)))+exp(y(46))*y(66);
residual(22) = T(94);
residual(23) = y(91)+params(25)*y(130)*(-params(15))+y(68)*(-(exp(y(43)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(48))))+y(67)*(-(T(5)*T(19)*T(16)*T(95)))+y(66)*(-(T(17)*T(3)*T(16)*T(96)))+y(64)*(-(T(51)*T(98)))+T(99)*(-params(16))*y(138);
residual(24) = T(102)+y(90)+T(105);
residual(25) = y(84)*(-(T(30)*params(4)*exp(y(50)*params(4))))+y(78)*y(56)*T(30)*params(4)*(params(4)-1)*exp(y(50)*(params(4)-1))+exp(y(50))*y(69);
residual(26) = y(89)*(-exp(y(51)))+exp(y(51))*y(87);
residual(27) = T(106);
residual(28) = T(107);
residual(29) = y(87)*T(108)+y(81)*T(109)+y(79)*params(22)*params(21)*(params(21)-1)*exp(y(54)*(params(21)-1))+y(69)*exp(y(17))*params(22)*params(21)*exp(params(21)*y(54))+T(110);
residual(30) = y(79)+y(77)*(-params(23))+y(76)+T(33)*y(23)*(-(T(24)*(1-exp(y(54)))));
residual(31) = params(4)*exp(y(50)*(params(4)-1))*T(30)*y(78)+y(77)+T(33)*y(24)*(-(T(24)*(1-params(23))));
residual(32) = y(93);
residual(33) = y(94);
residual(34) = y(95);
residual(35) = y(96);
residual(36) = y(97);
residual(37) = y(98);
residual(38) = T(26)*T(111)+exp(y(63))*y(92);
residual(39) = exp(y(41))-T(9)^T(10);
residual(40) = exp(y(26))-params(11)*T(12)*T(14);
residual(41) = exp(y(46))-T(3)*T(15)*T(16)*T(17);
residual(42) = exp(y(45))-T(5)*T(16)*T(18)*T(19);
residual(43) = exp(y(37))-exp(T(1)*y(48))*exp(y(13)*params(3))*exp(y(43)*(1-params(3)));
residual(44) = exp(y(44))+T(20)+exp(y(28))+exp(y(27))+exp(y(50))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(22)*exp(params(21)*y(54))*exp(y(17))+params(6)*exp(params(5)*y(10))*exp(y(6))-(exp(y(41))+exp(y(13))*(1-params(10)));
residual(45) = T(4)-T(21)*exp(y(46))^T(22);
residual(46) = 1-T(23)*(1+exp(y(108))-params(10));
residual(47) = T(24)-params(1)*T(26)/T(28);
residual(48) = y(38)-T(23)*(exp(y(36))*exp(y(101))+(1-exp(y(36)))*y(102)-params(6)*exp(params(5)*y(36)));
residual(49) = y(39)-(y(38)*params(7)+T(23)*(1-params(7))*y(103));
residual(50) = y(39)*params(4)*exp(y(28)*(params(4)-1))*T(29)-1;
residual(51) = T(23)*params(6)*params(5)*exp(y(36)*(params(5)-1))-T(23)*(exp(y(101))-y(102));
residual(52) = y(55)-T(23)*(exp(y(101))*exp(y(112))+(1-exp(y(112)))*y(113)-params(22)*exp(params(21)*y(112)));
residual(53) = y(56)-(y(55)*params(23)+T(23)*(1-params(23))*y(114));
residual(54) = y(56)*params(4)*exp(y(50)*(params(4)-1))*T(30)-1;
residual(55) = params(22)*params(21)*exp(y(54)*(params(21)-1))-(exp(y(26))-y(55));
residual(56) = exp(y(32))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(34)));
residual(57) = exp(y(52))-(exp(y(17))*(1-exp(y(54)))+params(23)*exp(y(53)));
residual(58) = exp(y(31))-(exp(y(6))*(1-exp((-y(49)))*exp(y(10)))+params(7)*exp(y(33)));
residual(59) = exp(y(34))-((1-params(7))*exp(y(9))+T(29)*exp(y(28)*params(4)));
residual(60) = exp(y(53))-((1-params(23))*exp(y(18))+T(30)*exp(y(50)*params(4)));
residual(61) = exp(y(33))-((1-params(7))*exp(y(8))+exp(y(27)*params(4))*T(31));
residual(62) = exp(y(30))-exp(y(7))*exp(y(11));
residual(63) = exp(y(51))-exp(y(17))*exp(y(54));
residual(64) = exp(y(29))-exp(y(6))*exp((-y(49)))*exp(y(10));
residual(65) = T(8)-(exp(y(51))+exp(y(30))+exp(y(29)));
residual(66) = y(49)-x(it_, 1);
residual(67) = y(48)-(x(it_, 2)+params(15)*y(16)+params(16)*y(25));
residual(68) = exp(y(63))-exp(y(10));
residual(69) = y(57)-(y(26)-y(1));
residual(70) = y(58)-(y(28)-y(3));
residual(71) = y(59)-(y(27)-y(2));
residual(72) = y(60)-(y(30)-y(5));
residual(73) = y(61)-(y(29)-y(4));
residual(74) = y(62)-(y(41)-y(12));
lhs = y(99);
rhs = y(130);
residual(75) = lhs - rhs;
lhs = y(100);
rhs = y(16);
residual(76) = lhs - rhs;

end
